/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.base;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.base.JVMSystemConstants;
import filenet.vw.base.PunycodeUtils;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWString;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.IVWConsoleHandler;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.logging.VWConsoleHandler;
import filenet.vw.base.logging.VWEventLogHandler;
import filenet.vw.base.util.SecureJSSEProps;
import filenet.vw.integrator.IVWAdaptorControl;
import filenet.vw.integrator.IVWComponentManager;
import filenet.vw.integrator.adaptors.webservices.VWWebServicesAdaptor;
import filenet.vw.integrator.base.VWAdaptorControl;
import filenet.vw.integrator.base.VWAdaptorControlEx;
import filenet.vw.integrator.base.VWCMConvertTwo;
import filenet.vw.integrator.base.VWEventListener;
import filenet.vw.server.VWCapsule;
import filenet.vw.server.VWCommandSession;
import filenet.vw.server.VWNoOnlineClassesException;
import filenet.vw.sysutils.VWRegistryTool;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.xml.rpc.JAXRPCException;

public class VWComponentManager
extends UnicastRemoteObject
implements IVWComponentManager {
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator");
    private static final String m_className = "VWComponentManager";
    private static Properties JSSE_PROPS = null;
    private static final long serialVersionUID = 7480L;
    protected Hashtable adaptor_control_list = new Hashtable();
    private Object m_adaptor_control_list_initialized_sync_Object = new Object();
    private boolean m_adaptor_control_list_initialized = false;
    private VWSession session = null;
    private static String CMRegistryName;
    private static final int KEY_MASK = 0;
    private String cmName;
    private int cmPort = 32771;
    private VWEventListener eventListener = null;
    private Boolean m_stopped = Boolean.FALSE;
    private static VWException AlreadyRunningException;
    private boolean isCustomService = false;
    public static final String ALL_QUEUES = "*";
    private String[] queueList = new String[]{"*"};
    private static String unexpectedExceptionStr;
    private MainThread m_mainThread = null;
    private static final String CMNAME_PREFIX = "FileNet.VW.VWComponentManager";
    private String s_notReady = new VWString("filenet.integrator.base.VWComponentManager.WaitingForSystem", "Component Manager is waiting to establish communication with the Process Engine. Please verify that Process Service on Process Engine is running.").toString();

    private static void traceJSSE_PROPS() {
        if (JSSE_PROPS != null && JSSE_PROPS.size() > 0) {
            StringBuilder b = new StringBuilder();
            Set<Object> keySet = JSSE_PROPS.keySet();
            for (Object key : keySet) {
                b.append(key).append("=").append(JSSE_PROPS.get(key)).append(",");
            }
            logger.info(m_className, "JSSEPROPS", b.toString());
        } else {
            logger.finest(m_className, "JSSEPROPS", "p8pejsse.properties file is not found.  No JSSE properties were set.");
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   25 Jan 2010 10:24:00  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.63  $";
    }

    private boolean onlyQueueIsIncluded(String queueName) {
        if (queueName == null || this.queueList == null || this.queueList.length == 0) {
            return false;
        }
        queueName = this.trimParensOffQueueName(queueName);
        return this.queueList.length == 1 && this.queueList[0].equals(queueName);
    }

    private String trimParensOffQueueName(String queueName) {
        int parenthesis = queueName.indexOf(40);
        if (parenthesis != -1) {
            queueName = queueName.substring(0, parenthesis);
        }
        return queueName;
    }

    private boolean queueIsIncluded(String queueName) {
        if (queueName == null || this.queueList == null || this.queueList.length == 0) {
            return false;
        }
        queueName = this.trimParensOffQueueName(queueName);
        int nQueues = this.queueList.length;
        for (int i = 0; i < nQueues; ++i) {
            if (this.queueList[i].equals(ALL_QUEUES)) {
                return true;
            }
            if (!this.queueList[i].equals(queueName)) continue;
            return true;
        }
        return false;
    }

    public static String maskPW(String pw) {
        int stringSize;
        StringBuffer buf = new StringBuffer();
        int n = stringSize = pw == null ? 0 : pw.length();
        if (stringSize > 0) {
            buf.append(pw.charAt(0));
        }
        for (int i = 1; i < stringSize; ++i) {
            buf.append("X");
        }
        return buf.toString();
    }

    private void getQueueList(String queues) {
        String[] queueList2 = queues.split(",");
        int nQueues = queueList2.length;
        Vector<String> v = new Vector<String>(nQueues);
        for (int i = 0; i < nQueues; ++i) {
            String q = queueList2[i];
            if (q.equals(ALL_QUEUES)) {
                return;
            }
            if (v.contains(q = this.trimParensOffQueueName(q))) continue;
            v.add(q);
        }
        this.queueList = v.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void CheckWcmApiConfigProperties(String suffix) {
        String m_method = "CheckWcmApiConfigProperties:" + suffix;
        String ceURISpecified = System.getProperty("filenet.pe.bootstrap.ceuri");
        if (ceURISpecified == null) {
            return;
        }
        if (System.getProperty("filenet.wcmapiconfig") != null) {
            return;
        }
        FileOutputStream out = null;
        try {
            int index = suffix.indexOf(CMNAME_PREFIX);
            index = index == -1 ? 0 : CMNAME_PREFIX.length();
            File f = File.createTempFile("WcmApiConfig", suffix.substring(index));
            f.deleteOnExit();
            out = new FileOutputStream(f);
            Properties p = new Properties();
            String v = "cemp:" + PunycodeUtils.toASCIIURL(ceURISpecified);
            p.setProperty("RemoteServerUrl", v);
            p.setProperty("RemoteServerUploadUrl", v);
            p.setProperty("RemoteServerDownloadUrl", v);
            p.store(out, suffix);
            out.close();
            out = null;
            String fName = f.getCanonicalPath();
            System.setProperty("filenet.wcmapiconfig", fName);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, fName);
            }
        }
        catch (Throwable t) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public VWComponentManager(String name, String username, String password, String routerurl, int cmport, int eventport, String queues) throws RemoteException {
        if (name == null) {
            name = CMRegistryName;
        }
        String m_method = "ctor:";
        StringBuffer buf = new StringBuffer("ctor:");
        buf.append("username=").append(username);
        buf.append(",").append(VWComponentManager.maskPW(password));
        buf.append(", routerURL=").append(routerurl);
        buf.append(", cmport:").append(cmport);
        buf.append(", eventport:").append(eventport);
        buf.append(", name:").append(name);
        buf.append(", queues:").append(queues);
        if (queues != null && !queues.equals(ALL_QUEUES)) {
            this.getQueueList(queues);
        }
        logger.entering(m_className, "ctor:");
        if (logger.isFinest()) {
            logger.finer(m_className, "ctor:", buf.toString());
        }
        this.cmPort = cmport;
        this.cmName = name;
        VWComponentManager.CheckWcmApiConfigProperties(this.cmName);
        try {
            this.init();
            this.m_mainThread = new MainThread(this, username, password, routerurl, eventport);
            this.m_mainThread.start();
        }
        catch (Exception e) {
            throw new RemoteException("CM.ctor", e);
        }
    }

    public VWComponentManager(String name, String username, String password, String routerurl, int cmport, int eventport, boolean customService, String queues) throws RemoteException {
        this(name, username, password, routerurl, cmport, eventport, queues);
        this.isCustomService = customService;
    }

    protected void start_ws_adaptors_from_controller() {
        String m_method = "start_ws_adaptors_from_controller";
        Enumeration e = this.adaptor_control_list.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("WSRequest")) continue;
            try {
                IVWAdaptorControl ac = (IVWAdaptorControl)this.adaptor_control_list.get(name);
                ac.start();
            }
            catch (Exception ex) {
                if (!logger.isFinest()) continue;
                logger.finest(m_className, m_method, "Failed to start " + name + ", ex=" + ex.getMessage());
            }
        }
    }

    protected void start_web_services_adaptors(String username, String password, String routerurl) throws Exception {
        if (this.session == null) {
            return;
        }
        String m_method = "start_web_services_adaptors";
        if (System.getProperty("filenet.PE.NOWS") != null) {
            logger.info(m_className, "start_web_services_adaptors", "WSRequest adaptors is disabled.");
            return;
        }
        logger.entering(m_className, "start_web_services_adaptors");
        String adaptor_name = "WSRequest(0)";
        if (!this.queueIsIncluded(adaptor_name)) {
            return;
        }
        VWQueue queue = this.session.getQueue(adaptor_name);
        VWWebServicesAdaptor.STATIC_INITIALIZER(this.session.getConnectionPointName());
        StringBuffer buf = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?><fnpe_webservices_component_descriptor xmlns=\"http://www.filenet.com/process\">");
        buf.append("<adaptor_name>").append(new VWString("component.webservices.adaptorname", "Web Services Component").toString()).append("</adaptor_name>");
        buf.append("<description>").append(new VWString("component.webservices.description", "This component handles the Web Services operations such as Invoke or Reply.").toString()).append("</description>");
        buf.append("<adaptor_class>filenet.vw.integrator.adaptors.webservices.VWWebServicesAdaptor");
        if (this.WSAdaptorSingleDispatcherEnabled()) {
            buf.append("Ex");
        }
        buf.append("</adaptor_class>");
        buf.append("<concurrent_threads>").append(VWWebServicesAdaptor.GetConcurentThreads()).append("</concurrent_threads>");
        buf.append("<polling_rate>");
        buf.append(VWWebServicesAdaptor.GetPollingRate());
        buf.append("</polling_rate><max_polling_rate>");
        buf.append(VWWebServicesAdaptor.GetMaxPollingRate());
        buf.append("</max_polling_rate><polling_increment>15000</polling_increment>");
        buf.append("<startup_mode>automatic</startup_mode>");
        buf.append("<exception_submap></exception_submap><jaas_username>");
        buf.append(username);
        buf.append("</jaas_username><jaas_password>").append(new VWCapsule(password).getStr());
        buf.append("</jaas_password><jaas_configcontext>PEWSLogin</jaas_configcontext><name>");
        buf.append(adaptor_name).append("</name><routerurl>");
        buf.append(routerurl).append("</routerurl><no_ui_stop>true</no_ui_stop></fnpe_webservices_component_descriptor>");
        String component_descriptor = buf.toString();
        if (logger.isFinest()) {
            logger.finer(m_className, "start_web_services_adaptors", "component descriptor:  " + component_descriptor);
        }
        UnicastRemoteObject ac = new VWAdaptorControl(queue, component_descriptor);
        ac = this.WSAdaptorSingleDispatcherEnabled() ? new VWAdaptorControlEx(queue, component_descriptor) : new VWAdaptorControl(queue, component_descriptor);
        try {
            ac.start();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.adaptor_control_list.put(adaptor_name, ac);
        logger.exiting(m_className, "start_web_services_adaptors");
    }

    protected boolean adaptorSingleDispatcherEnabled(VWXMLWrapper component_descriptor_doc, String qname) {
        String s = VWXMLWrapper.getNodeValue(component_descriptor_doc.getRootNode(), "single_dispatcher");
        if (s != null && s.equals("true")) {
            return true;
        }
        s = JVMSystemConstants.GetPrivilegedSystemProperty("filenet.pe.cm.adaptor.single.dispatcher." + qname);
        return s == null || !s.equals("false");
    }

    protected boolean WSAdaptorSingleDispatcherEnabled() {
        String s = JVMSystemConstants.GetPrivilegedSystemProperty("filenet.pe.cm.adaptor.single.dispatcher.WSRequest");
        return s == null || !s.equals("false");
    }

    protected void start_adaptors() throws Exception {
        if (this.session == null) {
            return;
        }
        String m_method = "start_adaptors";
        logger.entering(m_className, "start_adaptors");
        String[] qnames = this.session.fetchQueueNames(1);
        for (int i = 0; i < qnames.length; ++i) {
            String adaptor_name;
            String component_descriptor;
            if (!this.queueIsIncluded(qnames[i])) continue;
            VWQueue queue = null;
            VWQueueDefinition qdef = null;
            VWAttributeInfo attributes = null;
            queue = this.session.getQueue(qnames[i]);
            if (queue != null) {
                qdef = queue.fetchQueueDefinition();
            }
            if (qdef != null) {
                attributes = qdef.getAttributeInfo();
            }
            if (attributes == null || (component_descriptor = (String)attributes.getFieldValue("F_ComponentDescriptor")) == null) continue;
            VWXMLWrapper component_descriptor_doc = new VWXMLWrapper(component_descriptor);
            if (logger.isFinest()) {
                logger.finer(m_className, "start_adaptors", "component descriptor:  " + component_descriptor);
            }
            if ((adaptor_name = VWXMLWrapper.getNodeValue(component_descriptor_doc.getRootNode(), "name")) == null) {
                adaptor_name = qnames[i];
            }
            String startup_mode = VWXMLWrapper.getNodeValue(component_descriptor_doc.getRootNode(), "startup_mode");
            UnicastRemoteObject ac = null;
            ac = this.adaptorSingleDispatcherEnabled(component_descriptor_doc, qnames[i]) ? new VWAdaptorControlEx(queue, component_descriptor) : new VWAdaptorControl(queue, component_descriptor);
            if (startup_mode.equals("automatic")) {
                try {
                    ac.start();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.adaptor_control_list.put(adaptor_name, ac);
        }
        logger.exiting(m_className, "start_adaptors");
    }

    public boolean isCustomService() {
        return this.isCustomService;
    }

    protected void stop(boolean asCustomService) throws RemoteException {
        try {
            VWRegistryTool.unbind(this.cmName, this.cmPort);
            if (this.eventListener != null) {
                this.eventListener.stop();
            }
            this.stopAllAdaptors();
            if (this.session != null) {
                this.session.logoff();
            }
            boolean done = false;
            while (!done) {
                done = true;
                Enumeration ac_list = this.adaptor_control_list.elements();
                while (ac_list.hasMoreElements()) {
                    IVWAdaptorControl ac = (IVWAdaptorControl)ac_list.nextElement();
                    if (!ac.adaptorIsStarted()) continue;
                    done = false;
                }
                if (done) continue;
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, "stop", e);
        }
        logger.info(new VWString("filenet.vw.integrator.base.VWComponentManager.Stopped", "Component Manager stopped.").toString());
        VWConsoleHandler.deInstallGlobalHandler();
        if (!asCustomService) {
            System.exit(0);
        }
    }

    public void stop() throws RemoteException {
        this.m_stopped = Boolean.TRUE;
        this.stop(this.isCustomService());
    }

    public void startAdaptor(String adaptor_name) throws RemoteException {
        String m_method = "startAdaptor(" + adaptor_name + ")";
        logger.entering(m_className, m_method);
        try {
            IVWAdaptorControl ac = (IVWAdaptorControl)this.adaptor_control_list.get(adaptor_name);
            if (ac == null) {
                throw new VWException("vw.integrator.base.AdaptorDoesNotExist", "Failed to find adaptor control list: {0}.", adaptor_name);
            }
            ac.start();
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new RemoteException("VWComponentManager::startAdaptor", e);
        }
        logger.exiting(m_className, m_method);
    }

    public void startAllAdaptors() throws RemoteException {
        String m_method = "startAllAdaptors";
        logger.entering(m_className, "startAllAdaptors");
        try {
            Enumeration ac_list = this.adaptor_control_list.elements();
            while (ac_list.hasMoreElements()) {
                IVWAdaptorControl ac = (IVWAdaptorControl)ac_list.nextElement();
                if (ac.adaptorIsStarted()) continue;
                try {
                    ac.start();
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, "startAllAdaptors", e);
            throw new RemoteException("VWComponentManager::startAllAdaptors", e);
        }
        finally {
            logger.exiting(m_className, "startAllAdaptors");
        }
    }

    public void stopAdaptor(String adaptor_name) throws RemoteException {
        block6: {
            String m_method = "stopAdaptor(" + adaptor_name + ")";
            logger.entering(m_className, m_method);
            try {
                IVWAdaptorControl ac = (IVWAdaptorControl)this.adaptor_control_list.get(adaptor_name);
                if (ac != null) {
                    ac.stop();
                    break block6;
                }
                throw new VWException("vw.integrator.base.AdaptorDoesNotExist", "Failed to find adaptor control list: {0}.", adaptor_name);
            }
            catch (Exception e) {
                logger.throwing(m_className, m_method, e);
                throw new RemoteException("VWComponentManager::stopAdaptor", e);
            }
            finally {
                logger.exiting(m_className, m_method);
            }
        }
    }

    public void stopAllAdaptors() throws RemoteException {
        String m_method = "stopAllAdaptors";
        logger.entering(m_className, "stopAllAdaptors");
        try {
            Enumeration ac_list = this.adaptor_control_list.elements();
            while (ac_list.hasMoreElements()) {
                IVWAdaptorControl ac = (IVWAdaptorControl)ac_list.nextElement();
                ac.stop();
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, "stopAllAdaptors", e);
            throw new RemoteException("VWComponentManager::stopAllAdaptors", e);
        }
        finally {
            logger.exiting(m_className, "stopAllAdaptors");
        }
    }

    public void refreshAdaptor(String adaptor_name) throws RemoteException {
        block6: {
            String m_method = "refreshAdaptor(" + adaptor_name + ")";
            logger.entering(m_className, m_method);
            try {
                IVWAdaptorControl ac = (IVWAdaptorControl)this.adaptor_control_list.get(adaptor_name);
                if (ac != null) {
                    ac.refresh();
                    break block6;
                }
                throw new VWException("vw.integrator.base.AdaptorDoesNotExist", "Failed to find adaptor control list: {0}.", adaptor_name);
            }
            catch (Exception e) {
                logger.throwing(m_className, m_method, e);
                throw new RemoteException("VWComponentManager::refreshAdaptor", e);
            }
            finally {
                logger.exiting(m_className, m_method);
            }
        }
    }

    public void refreshAllAdaptors() throws RemoteException {
        String m_method = "refreshAllAdaptors";
        logger.entering(m_className, "refreshAllAdaptors");
        try {
            if (this.session == null) {
                return;
            }
            this.stopAllAdaptors();
            this.start_adaptors();
            this.start_ws_adaptors_from_controller();
        }
        catch (Exception e) {
            logger.throwing(m_className, "refreshAllAdaptors", e);
            throw new RemoteException("VWComponentManager::refreshAllAdaptors", e);
        }
        finally {
            logger.exiting(m_className, "refreshAllAdaptors");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAdaptorNames() throws RemoteException {
        String m_method = "getAdaptorNames";
        logger.entering(m_className, "getAdaptorNames");
        String[] adaptor_names = new String[]{};
        try {
            Object object = this.m_adaptor_control_list_initialized_sync_Object;
            synchronized (object) {
                if (!this.m_adaptor_control_list_initialized) {
                    for (int i = 0; i < 10; ++i) {
                        this.m_adaptor_control_list_initialized_sync_Object.wait(3000L);
                        if (this.m_adaptor_control_list_initialized) break;
                    }
                    if (!this.m_adaptor_control_list_initialized) {
                        logger.warning(m_className, "getAdaptorNames", this.s_notReady);
                        return new String[0];
                    }
                }
            }
            adaptor_names = this.adaptor_control_list.keySet().toArray(adaptor_names);
        }
        catch (Exception e) {
            logger.throwing(m_className, "getAdaptorNames", e);
            throw new RemoteException("VWComponentManager::getAdaptorNames", e);
        }
        logger.exiting(m_className, "getAdaptorNames", adaptor_names);
        return adaptor_names;
    }

    public IVWAdaptorControl getAdaptorControl(String adaptor_name) throws RemoteException {
        String m_method = "getAdaptorControl(" + adaptor_name + ")";
        logger.entering(m_className, m_method);
        IVWAdaptorControl ac = null;
        try {
            ac = (IVWAdaptorControl)this.adaptor_control_list.get(adaptor_name);
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new RemoteException("VWComponentManager::getAdaptorControl", e);
        }
        logger.exiting(m_className, m_method, ac);
        return ac;
    }

    public void resetCallTimeStatistics(String adaptor_name) throws RemoteException {
        String m_method = "resetCallTimeStatistics(" + adaptor_name + ")";
        logger.entering(m_className, m_method);
        try {
            IVWAdaptorControl ac = (IVWAdaptorControl)this.adaptor_control_list.get(adaptor_name);
            ac.resetCallTimeStatistics();
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new RemoteException("VWComponentManager::resetCallStats", e);
        }
        logger.exiting(m_className, m_method);
    }

    protected void processEvent(String[] queues) throws Exception {
        String m_method = "processEvent";
        logger.exiting(m_className, "processEvent");
        for (int i = 0; i < queues.length; ++i) {
            IVWAdaptorControl ac = (IVWAdaptorControl)this.adaptor_control_list.get(queues[i]);
            if (ac == null) continue;
            ac.triggerEvent();
        }
        logger.exiting(m_className, "processEvent");
    }

    public IVWConsoleHandler getConsoleHandler() throws RemoteException {
        VWConsoleHandler res = VWConsoleHandler.getGlobalHandler();
        if (res == null) {
            throw new RemoteException("VWConsoleHandler not found.");
        }
        return res;
    }

    private void init() throws RemoteException, Exception {
        String m_method = "init";
        try {
            Registry cmRegistry = LocateRegistry.getRegistry(this.cmPort);
            String[] list = cmRegistry.list();
            boolean prevRunning = false;
            for (int i = 0; i < list.length; ++i) {
                block5: {
                    if (list[i].compareTo(this.cmName) != 0) continue;
                    try {
                        IVWComponentManager temp = (IVWComponentManager)cmRegistry.lookup(this.cmName);
                        if (temp == null) break block5;
                        temp.getAdaptorNames();
                        prevRunning = true;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                if (!prevRunning) continue;
                throw AlreadyRunningException;
            }
        }
        catch (java.rmi.ConnectException connectException) {
            // empty catch block
        }
        VWRegistryTool.rebind(this.cmName, this, this.cmPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkWPSCredentials() {
        String fileName = JVMSystemConstants.GetPrivilegedSystemProperty("filenet.wps.uid.filename");
        if (fileName == null) {
            return;
        }
        FileInputStream inStream = null;
        try {
            Properties p = new Properties();
            inStream = new FileInputStream(fileName);
            p.load(inStream);
            Enumeration<Object> keys = p.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                key = key.equals("-1") ? "wps.uid" : "wps.uid." + key;
                System.setProperty(key, p.getProperty(key));
            }
        }
        catch (Throwable t) {
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAdaptorsCredentials() {
        String fileName = JVMSystemConstants.GetPrivilegedSystemProperty("filenet.adaptors.uid.filename");
        if (fileName == null) {
            return;
        }
        FileInputStream inStream = null;
        try {
            Properties p = new Properties();
            inStream = new FileInputStream(fileName);
            p.load(inStream);
            Enumeration<Object> keys = p.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                System.setProperty(VWAdaptorControlEx.formAdaptorCredentialPropertyName(key), p.getProperty(key));
            }
        }
        catch (Throwable t) {
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void main(String[] args) {
        block26: {
            String m_method = "main";
            try {
                boolean prevRunning;
                int eventPort;
                int cmPort;
                String queues;
                String cmName;
                String password;
                String username;
                String routerURL;
                block27: {
                    routerURL = null;
                    username = null;
                    password = null;
                    cmName = null;
                    queues = null;
                    cmPort = 32771;
                    eventPort = 0;
                    String UNBIND = "unbind";
                    String HELP = "?";
                    String ROUTER_URL = "routerURL";
                    String USER = "userName";
                    String PW = "password";
                    String CM_PORT = "registryPort";
                    String EVENT_PORT = "eventPort";
                    String CM_NAME = "registryName";
                    String QUEUES = "queues";
                    String NAMED_PARAMS = "named";
                    String[] argNames1 = new String[]{"routerURL", "userName", "password", "registryPort", "eventPort", "registryName"};
                    String[] argNames2 = new String[]{"unbind", "registryPort", "registryName"};
                    VWCommandLineArgs c = new VWCommandLineArgs(args, true);
                    String inputfile = c.getParameter("inputfile");
                    if (inputfile != null) {
                        c = new VWCommandLineArgs(inputfile, false);
                    }
                    if (c.isPresent("?") || args.length < 1) {
                        System.out.println("\nStartup Usage:\nVWComponentManager <routerURL> <username> <password> [registryPort] [eventPort] [registryName\n");
                        System.out.println("OR\nVWComponentManager /named /routerURL=<url> /userName=<name> /password=<password> /registryName=<CM Name> /registryPort=<port> /eventPort=<port>");
                        System.out.println();
                        System.out.println("Shutdown Usage:\n");
                        System.out.println("VWComponentManager unbind [registryPort] [CM Name -- must have registryPort defined]");
                        System.out.println("VWComponentManager /named /unbind /registryPort=<port> /registryName=<CMName>");
                        System.out.println();
                        System.exit(1);
                        break block26;
                    }
                    if (!c.isPresent("named")) {
                        c = args[0].equalsIgnoreCase("unbind") ? new VWCommandLineArgs(args, argNames2, true) : new VWCommandLineArgs(args, argNames1, true);
                    }
                    if (c.isPresent("unbind")) {
                        cmPort = c.getIntParameter("registryPort", 32771);
                        cmName = c.getParameter("registryName", CMRegistryName);
                        IVWComponentManager smi = (IVWComponentManager)Naming.lookup("rmi://localhost:" + cmPort + "/" + cmName);
                        if (smi != null) {
                            try {
                                smi.stop();
                            }
                            catch (Exception e) {
                                logger.throwing(m_className, "main", e);
                            }
                        }
                        if (logger.isFinest()) {
                            logger.finest(m_className, "main", "Unbound..");
                        }
                        System.exit(0);
                    }
                    routerURL = c.getParameter("routerURL");
                    username = c.getParameter("userName");
                    password = c.getParameter("password");
                    cmPort = c.getIntParameter("registryPort", 32771);
                    cmName = c.getParameter("registryName", CMRegistryName);
                    eventPort = c.getIntParameter("eventPort", 0);
                    queues = c.getParameter("queues", ALL_QUEUES);
                    prevRunning = false;
                    try {
                        IVWComponentManager smi = (IVWComponentManager)Naming.lookup("rmi://localhost:" + cmPort + "/" + cmName);
                        if (smi == null) break block27;
                        try {
                            String[] adaptorNames = smi.getAdaptorNames();
                            prevRunning = true;
                        }
                        catch (Exception orphanEx) {
                            if (logger.isFinest()) {
                                logger.finest(m_className, "main", "Found an orphan object, ex=" + orphanEx.getLocalizedMessage());
                            }
                            try {
                                VWRegistryTool.unbind(cmName, cmPort);
                            }
                            catch (Exception ex) {
                                if (logger.isFinest()) {
                                    logger.finest(m_className, "main", "Still got exception, just ignore it..ex=" + ex.getLocalizedMessage());
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (prevRunning) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, "main", "Component Manager " + cmName + " is already running.");
                    }
                    throw AlreadyRunningException;
                }
                VWComponentManager.checkWPSCredentials();
                VWComponentManager.checkAdaptorsCredentials();
                if (username.equals("-1")) {
                    VWCMConvertTwo converter = new VWCMConvertTwo(0);
                    VWAuthItem item = converter.getDString(password);
                    if (item != null) {
                        username = item.getName();
                        password = item.getPassword();
                        if (password != null && password.compareTo("\"\"") == 0) {
                            password = "";
                        }
                    } else {
                        if (logger.isFinest()) {
                            logger.finest(m_className, "main", "Invalid name or password.");
                        }
                        throw new VWException("vw.integrator.base.VWCMInvalidUserNamePassword", "User name or password is invalid.");
                    }
                }
                VWComponentManager cm = new VWComponentManager(cmName, username, password, routerURL, cmPort, eventPort, queues);
                if (logger.isFinest()) {
                    logger.finer(m_className, "main", "ComponentManager " + cmName + " bound in registry.");
                }
            }
            catch (Exception e) {
                System.err.println(e.getLocalizedMessage());
                logger.throwing(m_className, "main", e);
                System.exit(1);
            }
        }
    }

    static {
        try {
            JSSE_PROPS = SecureJSSEProps.SetJSSEProps();
        }
        catch (Exception e) {
            // empty catch block
        }
        VWEventLogHandler.installGlobalHandler(new VWString("filenet.integrator.base.VWComponentManager.ComponentManager", "Component Manager").toString());
        VWConsoleHandler.installGlobalHandler();
        long timeOut = 20000L;
        VWCommandSession.SetTimeout(timeOut);
        CMRegistryName = "FileNET.VW.VWComponentManager";
        AlreadyRunningException = new VWException("vw.integrator.base.VWCMAlreadyRunning", "You may not start more than one VWComponentManager process on a server.");
        unexpectedExceptionStr = new VWString("filenet.vw.integrator.base.VWComponentManager.UnexpectedException", "Unexpected Exception encountered.  Component Manager is stopped.").toString();
    }

    class MainThread
    extends Thread {
        private String userName = null;
        private String password = null;
        private String routerURL = null;
        private int eventPort = 0;
        private Throwable lastException = null;
        private VWComponentManager thisCM = null;

        public Throwable getLastException() {
            return this.lastException;
        }

        public MainThread(VWComponentManager aCM, String userName, String password, String routerURL, int eventPort) {
            this.thisCM = aCM;
            this.userName = userName;
            this.password = password;
            this.routerURL = routerURL;
            this.eventPort = eventPort;
            try {
                boolean IsWAS6;
                String namingFactoryClass = System.getProperty("java.naming.factory.initial");
                boolean bl = IsWAS6 = namingFactoryClass != null && namingFactoryClass.equals("com.ibm.websphere.naming.WsnInitialContextFactory");
                if (IsWAS6) {
                    InitialContext ic = new InitialContext();
                    ic.lookup("");
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.setName("CM-Thread:" + routerURL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block26: {
                boolean first = true;
                String m_method = "MainThread.run";
                while (true) {
                    try {
                        VWComponentManager.this.session = new VWSession(this.userName, this.password, this.routerURL);
                        if (VWComponentManager.this.queueIsIncluded("WSRequest")) {
                            VWComponentManager.this.start_web_services_adaptors(this.userName, this.password, this.routerURL);
                        }
                        if (!VWComponentManager.this.onlyQueueIsIncluded("WSRequest")) {
                            VWComponentManager.this.start_adaptors();
                        }
                        Object object = VWComponentManager.this.m_adaptor_control_list_initialized_sync_Object;
                        synchronized (object) {
                            VWComponentManager.this.m_adaptor_control_list_initialized = true;
                            VWComponentManager.this.m_adaptor_control_list_initialized_sync_Object.notify();
                        }
                        if (this.eventPort != 0) {
                            VWComponentManager.this.eventListener = new VWEventListener(this.eventPort, this.thisCM);
                            Thread t = new Thread(VWComponentManager.this.eventListener);
                            t.setName("CM-eventListener:" + this.eventPort);
                            t.start();
                        }
                        logger.info(VWComponentManager.m_className, m_method, new VWString("filenet.vw.integrator.base.VWComponentManager.Started", "Component Manager started.").toString());
                        VWComponentManager.traceJSSE_PROPS();
                        return;
                    }
                    catch (VWException vwe) {
                        boolean retryForDBReinit;
                        Throwable t = vwe.getRootCause();
                        boolean bl = retryForDBReinit = vwe.getMessage().indexOf("d56d0026") != -1;
                        if (retryForDBReinit || t instanceof NotBoundException || vwe instanceof VWNoOnlineClassesException || t instanceof JAXRPCException || t instanceof ConnectException) {
                            if (first) {
                                logger.warning(VWComponentManager.m_className, m_method, VWException.DescribeThrowableAndItsCause(vwe));
                                first = false;
                            }
                            if ((vwe instanceof VWNoOnlineClassesException || retryForDBReinit) && VWComponentManager.this.session != null) {
                                VWComponentManager.this.session.logoff();
                                VWComponentManager.this.session = null;
                            }
                        } else {
                            this.lastException = vwe;
                            if (this.lastException != null) {
                                System.err.println(VWException.DescribeThrowableAndItsCause(this.lastException));
                            } else {
                                System.err.println(unexpectedExceptionStr);
                            }
                            this.thisCM.stop();
                            return;
                        }
                        Thread.sleep(5000L);
                        if (!VWComponentManager.this.m_stopped.booleanValue()) continue;
                        if (VWComponentManager.this.m_stopped.booleanValue()) {
                            this.thisCM.stop();
                            return;
                        }
                        break block26;
                    }
                    catch (Exception e) {
                        logger.throwing(VWComponentManager.m_className, m_method, e);
                        try {
                            if (e != null) {
                                System.err.println(VWException.DescribeThrowableAndItsCause(e));
                            } else {
                                System.err.println(unexpectedExceptionStr);
                            }
                            this.thisCM.stop();
                        }
                        catch (Exception eee) {
                            // empty catch block
                        }
                        break block26;
                    }
                    break;
                }
                finally {
                    logger.exiting(VWComponentManager.m_className, m_method);
                }
            }
        }
    }
}

